
'Distributed Temperature-Sensing with DS18B20 Digital Thermometer

'Flash used:3648 bytes
'Bascom-Avr IDE [2.0.7.5]
'Micro:ATmega8A
'Sensors:DS18B20
'LCD:16X2 Alphanumeric Module
'January 29,2017
'**********************************************************
$regfile = "m8adef.dat"
$crystal = 8000000

Config Lcd = 16 * 2
Config Lcdpin = Pin , Db4 = Portb.0 , Db5 = Portb.1 , Db6 = Portb.2 , Db7 = Portb.3 , Rs = Portb.4 , E = Portb.5

Config Pinc.0 = Input : Portc.0 = 1 : Upkey Alias Pinc.0
Config Pinc.1 = Input : Portc.1 = 1 : Downkey Alias Pinc.1

Config Pinc.2 = Input : Portc.2 = 1 : Key1 Alias Pinc.2
Config Pinc.3 = Input : Portc.3 = 1 : Key2 Alias Pinc.3
Config Pinc.4 = Input : Portc.4 = 1 : Key3 Alias Pinc.4
Config Pinc.5 = Input : Portc.5 = 1 : Key4 Alias Pinc.5
Config Pind.7 = Input : Portd.7 = 1 : Alarmoffkey Alias Pind.7

'Configure the pin to use for 1WIRE statements
Config 1wire = Portd.0

Config Pind.1 = Input : Portd.1 = 1 : Selector Alias Pind.1 'Celsius/Fahreheit selector
Config Portd.2 = Output : Led1 Alias Portd.2
Config Portd.3 = Output : Led2 Alias Portd.3
Config Portd.4 = Output : Led3 Alias Portd.4
Config Portd.5 = Output : Led4 Alias Portd.5

Config Portd.6 = Output : Speaker Alias Portd.6
'***********************************************************
Declare Sub Sensors : Declare Sub Screen
Declare Sub Setting1 : Declare Sub Setting2
Declare Sub Setting3 : Declare Sub Setting4
Declare Sub Alarm

'***********************************************************

Dim Sensor1 As Integer , Sensor2 As Integer
Dim Sensor3 As Integer , Sensor4 As Integer

Dim Dsid1(8) As Byte , Dsid2(8) As Byte
Dim Dsid3(8) As Byte , Dsid4(8) As Byte

Dim Set1 As Integer , Set2 As Integer
Dim Set3 As Integer , Set4 As Integer

Dim Saved_key1 As Eram Integer , Saved_key2 As Eram Integer
Dim Saved_key3 As Eram Integer , Saved_key4 As Eram Integer

'***********************************************************
'Alarm settings saved into the EEPROM
Set1 = Saved_key1
Set2 = Saved_key2
Set3 = Saved_key3
Set4 = Saved_key4
'***********************************************************
Dsid1(1) = 1wsearchfirst()                                  'Read the first ID from the 1wire bus
Dsid2(1) = 1wsearchnext()                                   'Read the next ID from the 1wire bus
Dsid3(1) = 1wsearchnext()
Dsid4(1) = 1wsearchnext()
'***********************************************************
Do
Call Sensors
Call Screen
Call Setting1
Call Setting2
Call Setting3
Call Setting4
Call Alarm
Loop
End
'***********************************************************
Sub Sensors

1wreset                                                     'Issuing reset pulse and receiveing presence pulse
1wwrite &HCC                                                'issuing skip ROM command
1wwrite &H44                                                'Issuing convert t command
Waitms 750
'------------------
1wreset                                                     'Issuing reset pulse and receiving presence pulse
1wwrite &H55                                                'Issuing match ROM command
1wverify Dsid1(1)                                           'verifying if the ID is available on the 1wire bus
1wwrite &HBE                                                'Issuing scratchpad command to be allowed to read temperature information
Sensor1 = 1wread(2)                                         'Issuing read command to read temperature information
Sensor1 = Sensor1 \ 16                                      'Sensor1 temperature in degrees centigrade

'------------------
1wreset
1wwrite &H55
1wverify Dsid2(1)
1wwrite &HBE
Sensor2 = 1wread(2)
Sensor2 = Sensor2 \ 16
'------------------
1wreset
1wwrite &H55
1wverify Dsid3(1)
1wwrite &HBE
Sensor3 = 1wread(2)
Sensor3 = Sensor3 \ 16
'------------------
1wreset
1wwrite &H55
1wverify Dsid4(1)
1wwrite &HBE
Sensor4 = 1wread(2)
Sensor4 = Sensor4 \ 16
'------------------
'Celsius/Fahrenheit selector switch
If Selector = 0 Then Gosub Fahreinheit
End Sub
'***********************************************************
'LCD display temperature
Sub Screen
Cursor Off
Cls
If Key1 = 1 And Key2 = 1 And Key3 = 1 And Key4 = 1 Then
Locate 1 , 1
Lcd "S1:" ; Sensor1

Locate 1 , 9
Lcd "S2:" ; Sensor2

Locate 2 , 1
Lcd "S3:" ; Sensor3

Locate 2 , 9
Lcd "S4:" ; Sensor4

End If
'---------------------------------------------------------
'LCD display alarm settings
If Key1 = 0 Or Key2 = 0 Or Key3 = 0 Or Key4 = 0 Then
Cls
Locate 1 , 1
Lcd "A1:" ; Set1
Locate 1 , 9
Lcd "A2:" ; Set2
Locate 2 , 1
Lcd "A3:" ; Set3
Locate 2 , 9
Lcd "A4:" ; Set4
End If

'Resetting Alarm settings to 0
If Key1 = 0 And Key2 = 0 Then
Set1 = 0
Set2 = 0
Set3 = 0
Set4 = 0
End If

'Resetting alarm settings to 25

If Key2 = 0 And Key3 = 0 Then
Set1 = 25
Set2 = 25
Set3 = 25
Set4 = 25
End If

'Resetting alarm settings to 50
If Key3 = 0 And Key4 = 0 Then

Set1 = 50
Set2 = 50
Set3 = 50
Set4 = 50
End If
End Sub

'***********************************************************
'Converting degrees from Celsius into Fahrenheit for all sensors
Fahreinheit:
Sensor1 = Sensor1 * 18
Sensor1 = Sensor1 \ 10
Sensor1 = Sensor1 + 32

Sensor2 = Sensor2 * 18
Sensor2 = Sensor2 \ 10
Sensor2 = Sensor2 + 32

Sensor3 = Sensor3 * 18
Sensor3 = Sensor3 \ 10
Sensor3 = Sensor3 + 32

Sensor4 = Sensor4 * 18
Sensor4 = Sensor4 \ 10
Sensor4 = Sensor4 + 32
Return
'***********************************************************
'Alarm1 setting
Sub Setting1
If Key1 = 0 Then
If Upkey = 0 Then
Incr Set1

If Set1 > 125 Then Set1 = 125
End If


If Downkey = 0 Then
Decr Set1
If Set1 < -55 Then Set1 = -55

End If
End If
Saved_key1 = Set1
End Sub
'***********************************************************
'Alarm2 setting
Sub Setting2
If Key2 = 0 Then
If Upkey = 0 Then
Incr Set2

If Set2 > 125 Then Set2 = 125
End If


If Downkey = 0 Then
Decr Set2
If Set2 < -55 Then Set2 = -55

End If
End If
Saved_key2 = Set2
End Sub
'***********************************************************
'Alarm3 setting
Sub Setting3
If Key3 = 0 Then
If Upkey = 0 Then
Incr Set3

If Set3 > 125 Then Set3 = 125
End If


If Downkey = 0 Then
Decr Set3
If Set3 < -55 Then Set3 = -55

End If
End If
Saved_key3 = Set3
End Sub
'***********************************************************
'Alarm4 setting
Sub Setting4
If Key4 = 0 Then
If Upkey = 0 Then
Incr Set4

If Set4 > 125 Then Set4 = 125
End If


If Downkey = 0 Then
Decr Set4
If Set4 < -55 Then Set4 = -55

End If
End If
Saved_key4 = Set4
End Sub
'***********************************************************

Sub Alarm
If Alarmoffkey = 0 Then Goto Sensors                        'Switching All alarms off
'Flashing LED1 and producing distinct tone for alarm1
If Sensor1 > Set1 Then
Led1 = 1
Sound Speaker , 65 , 1274
Led1 = 0
End If

'Flashing LED2 and producing distinct tone for alarm2
If Sensor2 > Set2 Then
Led2 = 1
Sound Speaker , 98 , 850
Led2 = 0
End If

'Flashing LED3 and producing distinct tone for alarm3
If Sensor3 > Set3 Then
Led3 = 1
Sound Speaker , 110 , 758
Led3 = 0
End If

'Flashing LED4 and producing distinct tone for alarm4
If Sensor4 > Set4 Then
Led4 = 1
Sound Speaker , 87 , 954
Led4 = 0
End If
End Sub

'**********************************************************
'End of program